package xyz.zhiwei.article.morphism.appearance.discussion.viewpage;

import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.support.facet.LinkTwoListFacet;
import xyz.zhiwei.article.morphism.support.facet.Page;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSourcePage;

/**
 * 讨论列表分页
 */
public class DiscussionExplorerPage extends Page<DiscussionExplorerFacet>{
	private static final long serialVersionUID = 1L;
	
	
	/**
	 * 
	 * @param discussionList
	 * @param explorerList
	 */
	public DiscussionExplorerPage(List<Discussion> discussionList,List<Explorer> explorerList) {
		
		LinkTwoListFacet<DiscussionExplorerFacet> linkTwoListFacet=new LinkTwoListFacet<>(
				discussionList,explorerList,Discussion::getAuthorId, Explorer::getId,
				DiscussionExplorerFacet::new);

		Long total=((PrincipleSourcePage<Discussion>)discussionList).getTotal();
		
		this.addAll(linkTwoListFacet);
		this.setTotal(total);
	}
	

}
