package xyz.zhiwei.article.morphism.appearance.discussion.request;

import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

/**
 * 讨论提交申请扩展
 * 此构造方法不写在本原Discussion的原因：
 *     本原不应该依赖于抽象级别低的对象(DiscussionRequestInit)
 */
public class DiscussionRequestFacet extends Discussion{
	private static final long serialVersionUID = 1L;
	
	public DiscussionRequestFacet(DiscussionRequestInit init,Long authorId) {
		GenericMapper.INSTANCE.toPrinciple(init, this);
    	this.id=StaticSnowflake.generateId(1, TableIdEnum.DISCUSSION.getTableId());
		this.setAuthorId(authorId);
		this.setCheckStatus(0);
	}

}
