package xyz.zhiwei.article.morphism.appearance.discussion.request;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.article.morphism.principle.article.imagine.ConceptImagine;
import xyz.zhiwei.article.morphism.principle.article.imagine.ContributionImagine;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.image.TransactionGroupList;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 讨论提交申请
 */
public class DiscussionRequestAppearance extends SessionAppearance{

	//init
    private DiscussionRequestInit init;

    //=============原象=============
    private Source source;
    //当前用户的贡献值列表
    private List<Contribution> userContributionList;

    //=============构造=============
    //讨论本身
    private DiscussionRequestFacet discussionRequestFacet;
    
    //=============变换=============
    //生成文章讨论数
    private ConceptUpdateCountForDiscussionRequestFacet discussionUpdateCountFacet;

    //=============映象=============
    //新增讨论
    private Discussion newDiscussion;
    
    //概念统计更新值
    private List<Concept> updateIncConceptList;
    //贡献新增列表
    private List<Contribution> newContributionList;
    //贡献更新列表
    private List<Contribution> updateIncContributionList;
    

    //=============事务集=============
    //新增讨论
    private List<Discussion> newDiscussionTL;
    //概念统计更新值
    private List<Concept> updateIncConceptListTL;
    //贡献新增列表
    private List<Contribution> newContributionListTL;
    //贡献更新列表
    private List<Contribution> updateIncContributionListTL;
    
    
    
    //初始化
	public DiscussionRequestAppearance(String token,DiscussionRequestInit init) {
		super(token);
		this.init=init;
	}
	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);

        //用户的贡献值列表
		PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.explorerId(this.loginUser.getId());

		return new PrincipleQualifiers(contributionQualifier);
	};
    
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
	    this.userContributionList=this.source.userContributionList();
		
	    //讨论本身
	    this.discussionRequestFacet=new DiscussionRequestFacet(this.init,this.loginUser.getId());
	    
		return this;
	}
	
	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
		//讨论统计数
		this.discussionUpdateCountFacet=new ConceptUpdateCountForDiscussionRequestFacet(this.init.getSuperiorIdList());
		
		return this;
	}

	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

	    //新增讨论
	    this.newDiscussion=this.discussionRequestFacet;
	    
		//概念更新数
		this.updateIncConceptList=this.discussionUpdateCountFacet.getUpdateCountToConceptList();

		//贡献数分为新增和更新
		this.newContributionList=this.discussionUpdateCountFacet.getNewCountToContributionList(this.loginUser.getId(), this.userContributionList);
		this.updateIncContributionList=this.discussionUpdateCountFacet.getUpdateCountToContributionList(this.loginUser.getId(), this.userContributionList);
	    

		//======组成返回值======
	    this.newDiscussionTL=Arrays.asList(this.newDiscussion);
	    this.updateIncConceptListTL=ConceptImagine.updateInc(this.updateIncConceptList);
	    this.newContributionListTL=this.newContributionList;
	    this.updateIncContributionListTL=ContributionImagine.updateInc(this.updateIncContributionList);
		
		List<List<? extends Principle<?>>> addition=List.of(
				newDiscussionTL,
        		newContributionListTL);
		
		List<List<? extends Principle<?>>> modification=List.of(
				updateIncConceptListTL,
				updateIncContributionListTL);
		
		return new PrincipleImage(addition,modification);
		
	}

	public Discussion getNewDiscussion() {
		return newDiscussion;
	}

	
	/**
	 * 事务标识组
	 * @return
	 */
	@Override
	public TransactionGroupList transactionGroupList() {
		
		List<List<? extends Principle<?>>> groupA=Arrays.asList(
				newDiscussionTL
				);
		
		List<List<? extends Principle<?>>> groupB=Arrays.asList(
				newContributionListTL,
				updateIncConceptListTL,
				updateIncContributionListTL
				);

		return new TransactionGroupList(groupA,groupB);
	}; 
}
