package xyz.zhiwei.article.morphism.appearance.discussion.approve;

import java.util.List;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;


class Source extends SessionSource{
	
	
	/**
	 * 
	 * ---------super------------
	 * 
	 * 0: [登陆人       ,当前讨论  ]
	 * 0: [List<Session>,List<Discussion>]
	 * ---------------------------
	 * 
	 * 1.0-1: [当前版本概念的外延直属列表[currentId,....topId]]   
	 * 1.0-1: [List<Hierarchy>,                              ]
	 * 
	 */
	Source(List<PrincipleSource> principleSourceList) {
		super(principleSourceList);
	}

	/**
	 * 当前评审的讨论
	 * @param principleSourceList
	 * @return
	 */
	Discussion getDiscussion() {
		@SuppressWarnings("unchecked")
		List<Discussion> list=(List<Discussion>) this.principleSourceList.getFirst().get(1);
		return list.isEmpty() ? null : list.get(0);
	}
	
	
	/**
	 * 当前版本概念的外延直属列表[currentId,....topId]
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> getDirectlySuperiorHierarchy() {
	    return  (List<Hierarchy>) principleSourceList.get(1).getFirst();
	}
	
	
	
}
