package xyz.zhiwei.article.morphism.appearance.discussion.approve;

import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;

/**
 * 探索者贡献
 */
class ExplorerContributionFacet {
	
	private Contribution contribution;
	
	private Explorer explorer;
	
	
	public ExplorerContributionFacet(Discussion discussion,DiscussionApproveInit init) {
		if(null==init.getContribution() || init.getContribution()==0) {
			return;
		}

		//用户领域贡献值更新
		Contribution contributionUpdate=new Contribution();
		contributionUpdate.setExplorerId(discussion.getAuthorId());
		contributionUpdate.setConceptId(discussion.getConceptId());
		contributionUpdate.setContribution(init.getContribution());
		this.contribution=contributionUpdate;
		
		//用户总和贡献值更新
		Explorer explorer=new Explorer();
		explorer.setId(discussion.getAuthorId());
		explorer.setContribution(init.getContribution());
		this.explorer=explorer;
		
		
	}


	public Contribution getContribution() {
		return contribution;
	}


	public Explorer getExplorer() {
		return explorer;
	}

}
