package xyz.zhiwei.article.morphism.appearance.discussion.approve;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.article.morphism.principle.article.imagine.ConceptImagine;
import xyz.zhiwei.article.morphism.principle.article.imagine.ContributionImagine;
import xyz.zhiwei.article.morphism.principle.article.imagine.ExplorerImagine;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Discussion;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.DiscussionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.image.TransactionGroupList;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 讨论审批
 */
public class DiscussionApproveAppearance extends SessionAppearance{

	//init
    private DiscussionApproveInit init;

    //=============原象=============
    private Source source;
    //讨论本身
    private Discussion discussion;

    //当前版本概念的外延直属列表[currentId,....topId]
    private List<Hierarchy> superiorHierarchyList;

    
    
    //=============构造=============
    //讨论本身
    private DiscussionApproveFacet discussionApproveFacet;
    

    //=============变换=============
    //贡献值累加
    private ExplorerContributionFacet explorerContributionFacet;
    //生成文章讨论数
    private ConceptUpdateCountForDiscussionApproveFacet discussionUpdateCountFacet;

    //=============映象=============
    //更新讨论
    private Discussion updateDiscussion;
    //节点贡献值汇总
    private Contribution incContribution;
    //节点用户贡献值汇总
    private Explorer incExplorer;

    //概念统计更新值
    private List<Concept> updateIncConceptList;
    //贡献更新列表
    private List<Contribution> updateIncContributionList;

    
    
    //=============事务集=============

    //更新讨论
    private List<Discussion> updateDiscussionTL;
    //节点贡献值汇总
    private List<Contribution> incContributionTL;
    //节点用户贡献值汇总
    private List<Explorer> incExplorerTL;

    //概念统计更新值
    private List<Concept> updateIncConceptListTL;
    //贡献更新列表
    private List<Contribution> updateIncContributionListTL;
    
    
    
    
    //初始化
	public DiscussionApproveAppearance(String token,DiscussionApproveInit init) {
		super(token);
		this.init=init;
	}
	
	
	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	
    	//当前讨论
    	PrincipleQualifier<Discussion> idQualifier=DiscussionQualify.PQ.pk(this.init.getId());

		return principleQualifiers.addOne(idQualifier);
	};
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param relatedCollectionList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
    	this.source=new Source(principleSourceList);
    	this.discussion=this.source.getDiscussion();

    	//当前版本概念的外延直属列表[currentId,....topId]
    	PrincipleQualifier<Hierarchy> directlySuperiorHierarchyQualifier=HierarchyQualify.PQ.directlySuperiorHierarchyQualifier(this.discussion.getConceptId());


    	//用户所有的贡献列表
		PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.explorerId(this.discussion.getAuthorId());
	    
    	
    	return new PrincipleQualifiers(directlySuperiorHierarchyQualifier,contributionQualifier);
    	
    }
	
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.superiorHierarchyList=this.source.getDirectlySuperiorHierarchy();

		//讨论本身
	    this.discussionApproveFacet=new DiscussionApproveFacet(this.discussion);
		
        return this;
	}
	

	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
		//版本通过/拒绝标记
		this.discussionApproveFacet.approve(this.loginUser.getId(), this.init);

	    //贡献值累加
	    this.explorerContributionFacet=new ExplorerContributionFacet(this.discussion,this.init);

		//讨论统计数
		this.discussionUpdateCountFacet=new ConceptUpdateCountForDiscussionApproveFacet(this.init.getCheckStatus(),this.superiorHierarchyList);
	    
	    
		return this;
	}
	
	

	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

	    //更新讨论
	    this.updateDiscussion=this.discussionApproveFacet;

	    //节点贡献值汇总
	    this.incContribution=this.explorerContributionFacet.getContribution();
	    //节点用户贡献值汇总
	    this.incExplorer=this.explorerContributionFacet.getExplorer();

		//概念更新数
		this.updateIncConceptList=this.discussionUpdateCountFacet.getUpdateCountToConceptList();
	    //贡献更新列表
		this.updateIncContributionList=this.discussionUpdateCountFacet.getUpdateCountToContributionList(this.loginUser.getId());
		
		
		//======组成返回值======

	    this.updateDiscussionTL=Arrays.asList(this.updateDiscussion);
	    this.incContributionTL=ContributionImagine.updateInc(Arrays.asList(this.incContribution));
	    this.incExplorerTL=ExplorerImagine.updateInc(Arrays.asList(this.incExplorer));
	    this.updateIncConceptListTL=ConceptImagine.updateInc(this.updateIncConceptList);
	    this.updateIncContributionListTL=ContributionImagine.updateInc(this.updateIncContributionList);
		
		List<List<? extends Principle<?>>> modification=List.of(
				updateDiscussionTL,
				incContributionTL,
				incExplorerTL,
				updateIncConceptListTL,
				updateIncContributionListTL);
		
		return new PrincipleImage(null,modification);
		
	}
    
	

	/**
	 * 事务标识组
	 * @return
	 */
	@Override
	public TransactionGroupList transactionGroupList() {
		
		List<List<? extends Principle<?>>> groupA=Arrays.asList(
				updateDiscussionTL);

		List<List<? extends Principle<?>>> groupB=Arrays.asList(
				incContributionTL,
				incExplorerTL,
				updateIncConceptListTL,
				updateIncContributionListTL);
		
		return new TransactionGroupList(groupA,groupB);
	}; 
}
