package xyz.zhiwei.article.morphism.appearance.contribution.viewone;

import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 
 */
class Source{
	
	
	/**
	 * List<PrincipleSource>
	 * 0: [当前概念的直属下级列表] 
	 * 0: [List<Hierarchy>] 
	 * 
	 * 1: [节点概念信息列表, 用户的贡献值列表]
	 * 1: [List<Concept>,  List<Contribution>]
	 * 
	 * 
	 */
	private List<PrincipleSource> principleSourceList;
	
	
	Source(List<PrincipleSource> principleSourceList) {
		this.principleSourceList=principleSourceList;
	}

	/**
	 * 当前概念的外延直属列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> subHierarchyList() {
	    return (List<Hierarchy>) this.principleSourceList.getFirst().get(0);
	}
	
	/**
	 * 节点概念信息列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Concept> concetpList() {
	    return (List<Concept>) this.principleSourceList.get(1).get(0);
	}
	
	/**
	 * 用户的贡献列表
	 * @param this.principleSourceList
	 * @return
	 */
	List<Contribution> getContributionList() {
		@SuppressWarnings("unchecked")
		List<Contribution> list=(List<Contribution>) this.principleSourceList.get(1).get(1);
	    return list;
	}
}
