package xyz.zhiwei.article.morphism.appearance.contribution.viewone;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import xyz.zhiwei.article.morphism.facet.contribution.ConceptContributionViewFacet;
import xyz.zhiwei.article.morphism.facet.contribution.ConceptContributionViewInit;
import xyz.zhiwei.article.morphism.facet.hierarchy.HierarchyFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualify.ConceptQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;


/**
 * 贡献查看下一级
 * @author:Aureole
 */
public class ContributionViewOneAppearance implements Appearance{

	//init
    private ConceptContributionViewInit init;

    //=============原象=============
    private Source source;
	//当前概念的直属下级列表
    private List<Hierarchy> subHierarchyList;

    //节点概念信息列表
    private List<Concept> conceptList;
    //当前用户的贡献值列表
    private List<Contribution> userContributionList;
    
    //=============构造=============
    //层级结构
    private HierarchyFacet hierarchyFacet;
    //概念贡献层级
    private ConceptContributionViewFacet conceptContributionViewFacet;
    
    

    //初始化
	public ContributionViewOneAppearance(ConceptContributionViewInit init) {
		this.init=init;
	}
    
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

    	//当前概念的直属下级列表
    	PrincipleQualifier<Hierarchy> subHierarchyQualifier=HierarchyQualify.PQ.subHierarchyQualifier(this.init.getConceptId());

		return new PrincipleQualifiers(subHierarchyQualifier);
	};
	
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询：
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.subHierarchyList=this.source.subHierarchyList();
    	
    	//所有节点的概念值
    	PrincipleQualifier<Concept> conceptQualifier=ConceptQualify.PQ.hierarchyList(
    			Stream.concat(
    					Stream.of(new Hierarchy(this.init.getConceptId())),
    					this.subHierarchyList.stream()
					).collect(Collectors.toList()));
    	
        //用户的贡献值列表
		PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.explorerId(this.init.getExplorerId());
    	
		return new PrincipleQualifiers(conceptQualifier,contributionQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.conceptList=this.source.concetpList();
		this.userContributionList=this.source.getContributionList();
		
		//层级结构
		this.hierarchyFacet=new HierarchyFacet(
				new Hierarchy(this.init.getConceptId()),
				this.subHierarchyList);
		
		//带概念和贡献模型
		this.conceptContributionViewFacet=new ConceptContributionViewFacet(
				this.hierarchyFacet,
				this.conceptList,
				this.userContributionList);
		
		return this;
	}

	
	public ConceptContributionViewFacet getConceptContributionViewFacet() {
		return conceptContributionViewFacet;
	}
	
}