package xyz.zhiwei.article.morphism.appearance.concept.viewtwo;

import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 
 */
class Source{
	
	
	/**
	 * List<PrincipleSource>
	 * 0: [当前概念的直属下级列表] 
	 * 0: [List<Hierarchy>] 
	 * 
	 * 1: [每个直属下级的下级列表]
	 * 1: [List<Hierarchy>]
	 * 
	 * 2: [节点概念信息列表]
	 * 2: [List<Concept>]
	 * 
	 * 
	 */
	private List<PrincipleSource> principleSourceList;
	

	Source(List<PrincipleSource> principleSourceList) {
		this.principleSourceList=principleSourceList;
	}

	/**
	 * 当前概念的外延直属列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> subHierarchyList() {
	    return (List<Hierarchy>) this.principleSourceList.getFirst().get(0);
	}
	
	
	/**
	 * 每个直属下级的下级列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> secondInferiorList() {
	    return (List<Hierarchy>) this.principleSourceList.get(1).get(0);
	}
	
	/**
	 * 节点概念信息列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Concept> concetpList() {
	    return (List<Concept>) this.principleSourceList.get(2).get(0);
	}
	
}
