package xyz.zhiwei.article.morphism.appearance.concept.viewtwo;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import xyz.zhiwei.article.morphism.facet.concept.ConceptHierarchyFacet;
import xyz.zhiwei.article.morphism.facet.concept.ConceptViewInit;
import xyz.zhiwei.article.morphism.facet.hierarchy.HierarchyFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualify.ConceptQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;


/**
 * 概念查看两层
 * @author:Aureole
 */
public class ConceptViewTwoAppearance implements Appearance{

	//init
    private ConceptViewInit init;

    //=============原象=============
    private Source source;
	//当前概念的直属下级列表
    private List<Hierarchy> subHierarchyList;
    //每个直属下级的下级列表
    private List<Hierarchy> secondInferiorList;
    //节点概念信息列表
    private List<Concept> conceptList;
    
    //=============构造=============
    //层级结构
    private HierarchyFacet hierarchyFacet;
    //概念层级
    private ConceptHierarchyFacet conceptHierarchyFacet;
    
    

    //初始化
	public ConceptViewTwoAppearance(ConceptViewInit init) {
		this.init=init;
	}
    
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd,this::qualifierGroup3rd);
	}
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

    	//当前概念的直属下级列表
    	PrincipleQualifier<Hierarchy> subHierarchyQualifier=HierarchyQualify.PQ.subHierarchyQualifier(this.init.getConceptId());

		return new PrincipleQualifiers(subHierarchyQualifier);
	};
	
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询：
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.subHierarchyList=this.source.subHierarchyList();
    	
    	//每个直属下级的下级列表
    	PrincipleQualifier<Hierarchy> subsubHierarchyQualifier=HierarchyQualify.PQ.subHierarchyQualifier(this.subHierarchyList);
    	
		return new PrincipleQualifiers(subsubHierarchyQualifier);
	};
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第三次查询：
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup3rd(List<PrincipleSource> principleSourceList) {
    	this.secondInferiorList=this.source.secondInferiorList();

    	//所有节点的概念值
    	PrincipleQualifier<Concept> conceptQualifier=ConceptQualify.PQ.hierarchyList(
    			Stream.concat(
    				    Stream.of(new Hierarchy(this.init.getConceptId())),
    				    Stream.concat(subHierarchyList.stream(), secondInferiorList.stream())
    				).collect(Collectors.toList())
    			);
    	
		return new PrincipleQualifiers(conceptQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.conceptList=this.source.concetpList();
		
		//层级结构
		this.hierarchyFacet=new HierarchyFacet(
				new Hierarchy(this.init.getConceptId()),
				this.subHierarchyList,
				this.secondInferiorList);
		
		//带概念和贡献模型
		this.conceptHierarchyFacet=new ConceptHierarchyFacet(
				this.hierarchyFacet,
				this.conceptList);
		
		return this;
	}

	public ConceptHierarchyFacet getConceptHierarchyFacet() {
		return conceptHierarchyFacet;
	}

	
	
    
}