package xyz.zhiwei.article.morphism.appearance.article.view;

import java.util.List;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 
 */
class Source{
	
	
	/**
	 * List<PrincipleSource>
	 * 0: [文章本身，    文章段落] 
	 * 0: [List<Article>，List<Paragraph>] 
	 * 
	 * 1: [文章的最后更新人]
	 * 1: [List<Explorer>]
	 * 
	 * 
	 */
	private List<PrincipleSource> principleSourceList;
	
	Source(List<PrincipleSource> principleSourceList) {
		this.principleSourceList=principleSourceList;
	}

	
	/**
	 * 文章本身
	 * @param this.principleSourceList
	 * @return
	 */
	Article getArticle() {
		@SuppressWarnings("unchecked")
		List<Article> list=(List<Article>) this.principleSourceList.getFirst().getFirst();
		return list.isEmpty() ? null : list.get(0);
	}
	
	/**
	 * 当前节点的段落列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Paragraph> getParagraphList(){
	    return (List<Paragraph>) principleSourceList.get(0).get(1); 
	}
	
	
	/**
	 * 文章最后更新人
	 * @param this.principleSourceList
	 * @return
	 */
	Explorer getLastAuthor() {
		@SuppressWarnings("unchecked")
		List<Explorer> list=(List<Explorer>) this.principleSourceList.get(1).getFirst();
		return list.isEmpty() ? null : list.get(0);
	}
}
