package xyz.zhiwei.article.morphism.appearance.article.view;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.principle.article.model.Article;
import xyz.zhiwei.article.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.article.morphism.principle.article.qualify.ArticleQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ParagraphQualify;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.article.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;


/**
 * 文章表象
 */
public class ArticleViewAppearance implements Appearance{

	//init:conceptId
    private Long initConceptId;

    //=============原象=============
    private Source source;
    //文章摘要
    private Article article;
    //文章段落列表
    private List<Paragraph> paragraphList;
    //最后作者
    private Explorer lastAuthor;
    
    //=============构造=============
    //文章本身
    private ArticleFacet articleFacet;
    
    
    //初始化
	public ArticleViewAppearance(Long init) {
		this.initConceptId=init;
	}
	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一批查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
		//核心集定义：文章本身
    	PrincipleQualifier<Article> coreQualifier=ArticleQualify.PQ.pk(this.initConceptId);
		//关联集1定义：文章段落列表
    	PrincipleQualifier<Paragraph> paragraphQualifier=ParagraphQualify.PQ.conceptId(this.initConceptId);
		return new PrincipleQualifiers(coreQualifier,paragraphQualifier);
	};
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二批查询
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.article=this.source.getArticle();
    	
		//关联集2：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=ExplorerQualify.PQ.pk(article.getLastAuthorId());
		return new PrincipleQualifiers(explorerQualifier);
	};
	
	
	
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.paragraphList=this.source.getParagraphList();
		this.lastAuthor=this.source.getLastAuthor();
		
		//文章本身
		this.articleFacet=new ArticleFacet(this.article,this.paragraphList,this.lastAuthor);

        return this;
	}


	public ArticleFacet getArticleFacet() {
		return articleFacet;
	};
	
	
}