package xyz.zhiwei.article.morphism.appearance.article.request;

import java.util.List;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;


class Source extends SessionSource{
	
	
	/**
	 * 
	 * ---------super------------
	 * 0: [List<Session>]
	 * ---------------------------
	 * 
	 *    [当前概念的下级层级]
	 * 1: [List<Hierarchy>]
	 * 
	 *    [当前概念的下级概念,当前用户的贡献列表]
	 * 2: [List<Concept>,    List<Contribution>]
	 * 
	 */
	//private List<PrincipleSource> principleSourceList;
	
	
	Source(List<PrincipleSource> principleSourceList) {
		super(principleSourceList);
	}

	
	/**
	 * 当前概念的下级层级
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Hierarchy> fristInferiorList() {
	    return (List<Hierarchy>) this.principleSourceList.get(1).getFirst();
	}
	
	/**
	 * 当前概念的下级概念
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Concept> fristConceptList() {
	    return (List<Concept>) this.principleSourceList.get(2).getFirst();
	}
	
	
	/**
	 * 当前用户的贡献列表
	 * @param principleSourceList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Contribution> userContributionList(){
	    return (List<Contribution>) this.principleSourceList.get(2).get(1); 
	}
}
