package xyz.zhiwei.article.morphism.appearance.article.request;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.article.morphism.principle.edition.model.base.Connotation;
import xyz.zhiwei.article.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.article.morphism.support.util.StaticSnowflake;

class EditionForArticleUpdateFacet extends Edition{

	private static final long serialVersionUID = 1L;

	
	
	
	EditionForArticleUpdateFacet(Long eventId,Long explorerId,ArticleRequestInit init,
			List<Hierarchy> fristInferiorList,List<Concept> fristConceptList) {
		Long editionId=StaticSnowflake.generateId(1, TableIdEnum.EDITION.getTableId());
    	this.id=editionId;
    	setEventId(eventId);
    	setConceptId(init.getId());
    	setAuthorId(explorerId);
    	setCreateTime(new Date());
    	setCheckStatus(0);
		
    	setConcept(init.getName());
    	setDigest(init.getUpdateAbstract());
    	setCentralIdea(init.getCentralIdea());
    	setReference(init.getReference());
    	setParagraphList(init.getParagraphList()); 
		
    	
		//内涵空间
    	Map<Long, Concept> conceptMap = fristConceptList.stream().collect(Collectors.toMap(Concept::getId, Function.identity()));
		List<Connotation> connotationList=fristInferiorList.stream().map(h-> new Connotation(h)).collect(Collectors.toList());
		connotationList.stream().forEach(c ->c.setName(conceptMap.get(c.getId()).getName()));
		
		setConnotationList(connotationList);
    }
    
}
