package xyz.zhiwei.article.morphism.appearance.article.request;

import java.util.List;

import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountCombineListFacet;
import xyz.zhiwei.article.morphism.facet.concept.ConceptUpdateCountFacet;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.support.util.DeepClone;

/**
 * 生成文章编辑请求数: 
 */
class ConceptUpdateCountForArticleRequestFacet{
	//当前概念编辑数+1
	private ConceptUpdateCountFacet thisConceptUpdateCount;

	//合并更新数
	private ConceptUpdateCountCombineListFacet conceptUpdateCountCombineList;
	
	
	
	
	ConceptUpdateCountForArticleRequestFacet(List<Long> superiorIdList) {
		this.thisConceptUpdateCount=new ConceptUpdateCountFacet(DeepClone.deepClone(superiorIdList));
		thisConceptUpdateCount.setCountEditCompOrArt(1);
		thisConceptUpdateCount.setIsEditCompOrArt(1);
		
		this.conceptUpdateCountCombineList=new ConceptUpdateCountCombineListFacet(thisConceptUpdateCount);
	}
	
    /**
     * 更新的统计数转概念列表
     * @param combineUpdateConutList
     * @return
     */
	List<Concept> getUpdateCountToConceptList() {
		return this.conceptUpdateCountCombineList.getUpdateCountToConceptList(ConceptUpdateCountFacet::requestToConcept);
	}
	

    /**
     * 更新统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getUpdateCountToContributionList(Long explorerId,List<Contribution> userContributionList) {
		return this.conceptUpdateCountCombineList.getUpdateCountToContributionList(
				explorerId,userContributionList,
				(oneUpdateCount, eId) -> oneUpdateCount.requestToContribution(eId));
	}
    
    /**
     * 新增统计数转贡献列表
     * @param explorerId
     * @return
     */
	List<Contribution> getNewCountToContributionList(Long explorerId,List<Contribution> userContributionList) {
		return this.conceptUpdateCountCombineList.getNewCountToContributionList(
				explorerId,userContributionList,
				(oneUpdateCount, eId) -> oneUpdateCount.requestToContribution(eId));
	}
	
	
}
