package xyz.zhiwei.article.morphism.appearance.article.request;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.article.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.article.morphism.principle.article.imagine.ConceptImagine;
import xyz.zhiwei.article.morphism.principle.article.imagine.ContributionImagine;
import xyz.zhiwei.article.morphism.principle.article.model.Concept;
import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.model.ParagraphPicture;
import xyz.zhiwei.article.morphism.principle.article.qualify.ConceptQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.article.morphism.principle.article.qualify.HierarchyQualify;
import xyz.zhiwei.article.morphism.principle.edition.model.EditEvent;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.image.TransactionGroupList;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;

/**
 * 文章更新申请
 */
public class ArticleRequestAppearance extends SessionAppearance{

	//init
    private ArticleRequestInit init;

    //=============原象=============
    private Source source;
    //当前概念的下级节点
    private List<Hierarchy> fristInferiorList;
    //当前概念的下级节点
    private List<Concept> fristConceptList;
    //当前用户的贡献值列表
    private List<Contribution> userContributionList;
    
    
    //=============构造=============

    //事件标识
    private EditEvent editEventModel;
    //生成版本
    private Edition articleEditionModel;
    
    //=============变换=============
    //生成文章编辑数
    private ConceptUpdateCountForArticleRequestFacet articleUpdateCountFacet;


    //=============映象=============
    //新增事件标识
    private EditEvent newEditEventModel;
    //新增版本
    private Edition newArticleEdition;
    //新增段落图片列表
    private List<ParagraphPicture> newParagraphPictureList;

    //概念统计更新值
    private List<Concept> updateIncConceptList;

    //贡献新增列表
    private List<Contribution> newContributionList;
    //贡献更新列表
    private List<Contribution> updateIncContributionList;
    

    //=============事务集=============

    //新增事件标识
    private List<EditEvent> newEditEventModelTL;
    //新增版本
    private List<Edition> newArticleEditionTL;
    //概念统计更新值
    private List<Concept> updateIncConceptListTL;
    //贡献新增列表
    private List<Contribution> newContributionListTL;
    //贡献更新列表
    private List<Contribution> updateIncContributionListTL;
    
    

    //初始化
	public ArticleRequestAppearance(String token,ArticleRequestInit init) {
		super(token);
		this.init=init;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd,this::qualifierGroup3rd);
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询
	 *    1  当前概念的下级层级
	 * @param principleSourceList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
		//当前概念的下级层级
        PrincipleQualifier<Hierarchy> subHierarchyQualifier=HierarchyQualify.PQ.subHierarchyQualifier(this.init.getId());

		return new PrincipleQualifiers(subHierarchyQualifier);
	};
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第三次查询
	 *    1  当前概念的下级层级的概念
	 *    2  当前用户的贡献值列表
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup3rd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.fristInferiorList=this.source.fristInferiorList();

		//当前概念的下级层级的概念
        PrincipleQualifier<Concept> hierarchyIdListQualifier=ConceptQualify.PQ.hierarchyList(this.fristInferiorList);

        //用户的贡献值列表
		PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.explorerId(this.loginUser.getId());
        
		return new PrincipleQualifiers(hierarchyIdListQualifier,contributionQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.fristConceptList=this.source.fristConceptList();
	    this.userContributionList=this.source.userContributionList();
		
	    
        //事件标识
		this.editEventModel=new EditEvent(this.loginUser.getId());

		//构造版本模型
		this.articleEditionModel=new EditionForArticleUpdateFacet(editEventModel.getId(), this.loginUser.getId(), this.init,
				this.fristInferiorList,this.fristConceptList);
		
		

        return this;
	};

	


	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
		//文章统计数
		this.articleUpdateCountFacet=new ConceptUpdateCountForArticleRequestFacet(this.init.getSuperiorIdList());
		
		return this;
	}
	

	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

		//事件标识
		this.newEditEventModel=this.editEventModel;
	    //生成版本
	    this.newArticleEdition=this.articleEditionModel;

	    //新增段落图片列表
	    this.newParagraphPictureList=this.init.paragraphPictureList(this.loginUser.getId());

		//概念更新数
		this.updateIncConceptList=this.articleUpdateCountFacet.getUpdateCountToConceptList();

		//贡献数分为新增和更新
		this.newContributionList=this.articleUpdateCountFacet.getNewCountToContributionList(this.loginUser.getId(), this.userContributionList);
		this.updateIncContributionList=this.articleUpdateCountFacet.getUpdateCountToContributionList(this.loginUser.getId(), this.userContributionList);
	    
	    
		//======组成返回值======

	    this.newEditEventModelTL=Arrays.asList(this.newEditEventModel);
	    this.newArticleEditionTL=Arrays.asList(this.newArticleEdition);
	    this.updateIncConceptListTL=ConceptImagine.updateInc(this.updateIncConceptList);
	    this.newContributionListTL=this.newContributionList;
	    this.updateIncContributionListTL=ContributionImagine.updateInc(this.updateIncContributionList);
	    
		List<List<? extends Principle<?>>> addition=Arrays.asList(
				this.newEditEventModelTL,
				this.newArticleEditionTL,
        		this.newParagraphPictureList,
        		this.newContributionListTL);
		
		List<List<? extends Principle<?>>> modification=Arrays.asList(
				this.updateIncConceptListTL,
				this.updateIncContributionListTL);
		
		return new PrincipleImage(addition,modification);
	};
	
	

	/**
	 * 事务标识组
	 * @return
	 */
	@Override
	public TransactionGroupList transactionGroupList() {
		
		List<List<? extends Principle<?>>> groupA=Arrays.asList(
				this.newEditEventModelTL,
				this.newArticleEditionTL,
        		this.newParagraphPictureList,
        		this.newContributionListTL,
				this.updateIncConceptListTL,
				this.updateIncContributionListTL);

		return new TransactionGroupList(groupA);
	}; 
	
}
