package xyz.zhiwei.article.dao.impl.rpc.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import xyz.zhiwei.cognitivedesign.dao.impl.rpc.config.FeignProxyUtil;
import xyz.zhiwei.edition.api.EditionApi;
import xyz.zhiwei.edition.api.EventApi;
import xyz.zhiwei.explorer.api.ExplorerApi;

/**
 * Feign代理创建配置
 */
@Configuration
public class RpcApiImplConfig  {

    // 注入Spring管理的FeignProxyUtil实例
    private final FeignProxyUtil feignProxyUtil;
    public RpcApiImplConfig(FeignProxyUtil feignProxyUtil) {
        this.feignProxyUtil = feignProxyUtil;
    }

    
    
	//服务模块级别的路径，explorer这里是指explorer项目，而不是explorer本原
    @Value("${micrsvcaddress.explorer}")
    private String explorerApiUrl;
    @Value("${micrsvcaddress.edition}")
    private String editionApiUrl;
    
    
    @Bean
    public ExplorerApi explorerApi() {
        return feignProxyUtil.createProxy(ExplorerApi.class, explorerApiUrl);
    }

    @Bean
    public EditionApi editionApi() {
        return feignProxyUtil.createProxy(EditionApi.class, editionApiUrl);
    }
    
    @Bean
    public EventApi eventApi() {
        return feignProxyUtil.createProxy(EventApi.class, editionApiUrl);
    }
}
