package xyz.zhiwei.article.dao.impl.rpc;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import xyz.zhiwei.article.dao.impl.rpc.mapper.GenericMapper;
import xyz.zhiwei.article.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.cognitivedesign.dao.impl.rpc.BaseRpcDaoImpl;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.api.ExplorerApi;
import xyz.zhiwei.explorer.api.support.Message;


@Repository
public class ExplorerDaoImpl extends BaseRpcDaoImpl<Explorer> {

	@Autowired
	private ExplorerApi explorerApi;
	


	/**
	 * id查询
	 * @param qualifier
	 * @return
	 */
	List<Explorer> pk(PrincipleQualifier<Explorer> qualifier) {
        return Stream.of(pk(qualifier.getSimilar())).toList();
	}
	Explorer pk(Explorer p) {
		Message<xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer> msg=explorerApi.queryone(p);
		if(null!=msg) {
			return GenericMapper.INSTANCE.toPr(msg.getResult());
		}
		return null;
	}

	/**
	 * id列表查询
	 * @param qualifier
	 * @return
	 */
    protected List<Explorer> pkList(PrincipleQualifier<Explorer> qualifier){
    	return pkList(qualifier.getSimilarList());
	}
    protected List<Explorer> pkList(List<Explorer> similarList){
		if(null==similarList|| similarList.size()==0){
			return new ArrayList<>();
		}
		
		List<Principle<Long>> condition=GenericMapper.INSTANCE.toExplorerIdList(similarList);
		Message<List<xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer>> msg=explorerApi.queryids(condition);
		if(null!=msg) {
			return GenericMapper.INSTANCE.toExplorerPr(msg.getResult());
		}
		return new ArrayList<>();
	}

    
    
    /**
     * 更新
     */
	@Override
	protected Long updateList(List<Explorer> list) {
		List<xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer> poList=GenericMapper.INSTANCE.toExplorerList(list);
		Message<Long> msg=explorerApi.updateList(poList);
		if(null!=msg) {
			return msg.getResult();
		}
		return 0L;
	}
	
    
}