package xyz.zhiwei.article.dao.impl.rpc;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import xyz.zhiwei.article.dao.impl.rpc.mapper.GenericMapper;
import xyz.zhiwei.article.morphism.principle.edition.model.Edition;
import xyz.zhiwei.cognitivedesign.dao.impl.rpc.BaseRpcDaoImpl;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.edition.api.EditionApi;
import xyz.zhiwei.edition.api.support.Message;


@Repository
public class EditionDaoImpl extends BaseRpcDaoImpl<Edition> {

	@Autowired
	private EditionApi editionApi;
	

	//==========================================保存区===========================================
	

	@Override
	protected Long addList(List<Edition> list) {
		List<xyz.zhiwei.edition.morphism.principle.edition.model.Edition> poList=GenericMapper.INSTANCE.toEditionList(list);
		Message<Long> msg=editionApi.addList(poList);
		if(null!=msg) {
			return msg.getResult();
		}
		return 0L;
	}
	
	@Override
	protected Long updateList(List<Edition> list) {
		List<xyz.zhiwei.edition.morphism.principle.edition.model.Edition> poList=GenericMapper.INSTANCE.toEditionList(list);
		Message<Long> msg=editionApi.updateList(poList);
		if(null!=msg) {
			return msg.getResult();
		}
		return 0L;
	}

	//==========================================查询区===========================================

	
	
	
	
	/**
	 * id查询
	 * @param qualifier
	 * @return
	 */
	List<Edition> pk(PrincipleQualifier<Edition> qualifier) {
        return Stream.of(pk(qualifier.getSimilar())).toList();
	}
	Edition pk(Edition p) {
		Message<xyz.zhiwei.edition.morphism.principle.edition.model.Edition> msg=editionApi.queryonesimple(p);
		if(null!=msg) {
			return GenericMapper.INSTANCE.toPr(msg.getResult());
		}
		return null;
	}

	
	
	/**
	 * fK查询
	 * @param qualifier
	 * @return
	 */
    List<Edition> fk(PrincipleQualifier<Edition> qualifier) {
        return fk(qualifier.getSimilar());
    }
    List<Edition> fk(Edition p) {
    	xyz.zhiwei.edition.morphism.principle.edition.model.Edition condition=GenericMapper.INSTANCE.toPo(p);
		Message<List<xyz.zhiwei.edition.morphism.principle.edition.model.Edition>> msg=editionApi.queryfk(condition);
		if(null!=msg) {
			return GenericMapper.INSTANCE.toEditionPr(msg.getResult());
		}
		return new ArrayList<>();
    }
	
	
	/**
	 * 查询上一个版本
	 * @param qualifier
	 * @return
	 */
	List<Edition> queryLastOne(PrincipleQualifier<Edition> qualifier) {
    	xyz.zhiwei.edition.morphism.principle.edition.model.Edition condition=GenericMapper.INSTANCE.toPo(qualifier.getSimilar());
		Message<xyz.zhiwei.edition.morphism.principle.edition.model.Edition> msg=editionApi.querylastedition(condition);
		if(null!=msg) {
			return Stream.of(GenericMapper.INSTANCE.toPr(msg.getResult())).toList();
		}
		return new ArrayList<>();
	}
    
	
	

}