package xyz.zhiwei.article.dao.impl.rdb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.stereotype.Repository;

import xyz.zhiwei.article.morphism.principle.article.imagery.HierarchyDelRecursionImagery;
import xyz.zhiwei.article.morphism.principle.article.model.Hierarchy;
import xyz.zhiwei.article.morphism.principle.article.qualifier.HierarchySuperiorListOnPartCondition;
import xyz.zhiwei.article.morphism.principle.article.qualifier.HierarchySuperiorListOnPartQualifier;
import xyz.zhiwei.article.morphism.principle.edition.model.base.ConnotationDifference;
import xyz.zhiwei.cognitivedesign.dao.impl.rdb.BaseRdbDaoImpl;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;

/**
 * @author:Aureole
 * 
 */
@Repository
public class HierarchyDaoImpl extends BaseRdbDaoImpl<Hierarchy> {


	

	/**
	 * 查询外延直属概念列表
	 * @param forSuperiorIdListOnPartConditionList
	 * @return
	 */
	List<Hierarchy> querySuperiorIdListOfList(HierarchySuperiorListOnPartQualifier hierarchySuperiorListOnPartQualifier){
		List<HierarchySuperiorListOnPartCondition> forSuperiorIdListOnPartConditionList=hierarchySuperiorListOnPartQualifier.getForSuperiorIdListOnPartConditionList();
		List<Hierarchy> allHierarchy=new ArrayList<Hierarchy>();

		for (HierarchySuperiorListOnPartCondition hierarchySuperiorListOnPartCondition : forSuperiorIdListOnPartConditionList) {
			Long conceptId=hierarchySuperiorListOnPartCondition.getConceptId();
			List<Long> superiorIdList=querySuperiorIdListOnPart(conceptId,hierarchySuperiorListOnPartCondition.getPartIdList(),hierarchySuperiorListOnPartCondition.getEditingSuperIdList());
			
			List<Hierarchy> oneSuperHierarchyList=superiorIdList.stream().map(id -> new Hierarchy(id,conceptId)).collect(Collectors.toList());
			allHierarchy.addAll(oneSuperHierarchyList);
		}
		
		return allHierarchy;
	}
	
	
	/**
	 * 查询外延直属概念列表
	 * @param forSuperiorIdListOnPartConditionList
	 * @return
	 */
	List<Hierarchy> querySuperiorIdListGroup(PrincipleQualifier<Hierarchy> qualifier){
		
		List<Hierarchy> allHierarchy=new ArrayList<Hierarchy>();

		for (Hierarchy hierarchy : qualifier.getSimilarList()) {
			List<Hierarchy> superiorHierarchyList=querySuperiorList(hierarchy);
			superiorHierarchyList.stream().forEach(h->h.setSuperiorId(hierarchy.getConceptId()));
			
			allHierarchy.addAll(superiorHierarchyList);
		}
		
		return allHierarchy;
	}
	
	

	
	/**
	 * 查询当前概念的外延直属列表
	 * @param Hierarchy {conceptId}
	 * @return 包含自身 到 顶级概念 的概念列表 ，概念层级信息都是完整的。
	 * [currentId,....topId]
	 */
	List<Hierarchy> querySuperiorList(PrincipleQualifier<Hierarchy> qualifier) {
		return querySuperiorList(qualifier.getSimilar());
	}
	
	

	/**
	 * 递归删除
	 * {superiorId,conceptId}
	 */
    Long deleteRecursive(HierarchyDelRecursionImagery hierarchyDelRecursionImagery){
    	List<Hierarchy> list=hierarchyDelRecursionImagery;
    	Map<Long,ConnotationDifference> moveAddConceptMap=hierarchyDelRecursionImagery.getEventAddConceptMap();
    	
		Long count=0L;
		if(null!=list && list.size()>0){
			for (int i = 0; i < list.size(); i++) {
				count+=deleteRecursiveLimit(list.get(i),moveAddConceptMap);
			}
		}
		
    	return count;
    }
	

	/**
	 * 递归删除， 如果遇到是移除到别的节点的，则只删除当前关系。
	 * 节点删除时，按理要删除其所有子节点(递归)
	 * 例外的是，当某个子节点是被移动到别的节点，那么该节点的子节点不能删除，而只能删除该节点本身。
	 * 
	 * {superiorId,conceptId}
	 */
    private int deleteRecursiveLimit(Hierarchy hierarchyModel,Map<Long,ConnotationDifference> moveAddConceptMap){
		Long conceptId=hierarchyModel.getConceptId();
		int count=0;
		
		//查询子层级
		Hierarchy supHierarchy=new Hierarchy();
		supHierarchy.setSuperiorId(conceptId);
		
		List<Hierarchy> inferiorList=fk(supHierarchy);
		if(null!=inferiorList && inferiorList.size()>0){
			for (int i = 0; i < inferiorList.size(); i++) {
				Hierarchy oneInferior=inferiorList.get(i);
				Long inferiorConceptId=oneInferior.getConceptId();
				if(moveAddConceptMap.containsKey(inferiorConceptId)) {
					count+=deleteList(List.of(oneInferior));
				}else {
					count+=deleteRecursiveLimit(oneInferior,moveAddConceptMap);
				}
			}
		}
		
		count+=deleteList(List.of(hierarchyModel));
		
    	return count;
    }

	
	
	/**
	 * 查询当前概念的外延直属列表
	 * @param hierarchy {conceptId}
	 * @return 包含自身 到 顶级概念 的概念列表 ，概念层级信息都是完整的。
	 * [currentId,....topId]
	 * 
	 * 情况1 入参节点不是top1
	 *     返回：[currentId,....topId]
	 * 
	 * 情况2 入参节点就是top1
	 *      返回：[top1]
	 * 
	 * 情况3 入参节点在层级中已删除
	 *      返回：[currentId]
	 */
	private List<Hierarchy> querySuperiorList(Hierarchy hierarchy) {
		

		//===========数据结构定义===========
		List<Hierarchy> superiorList=new ArrayList<Hierarchy>();
		
		//当前需要分析的概念
		Hierarchy nowHierarchy;

		//下一次需要分析的概念
		Hierarchy nextHierarchy;
		

		//===========初始化===========
		nowHierarchy=hierarchy;
		
		

		//===========递归操作准入条件===========
		//最后的情况是：nowHierarchy.ConceptId=1;退出了循环。
		//也即ConceptId=1的下级都加入到了列表。但ConceptId=1未加入。
		while(null!=nowHierarchy && 1!= nowHierarchy.getConceptId()){
			
			nowHierarchy=pk(nowHierarchy);
			
			if(null==nowHierarchy){
				break;
			}else{
				if(null==nowHierarchy.getSuperiorId()){
					break;
				}
			}
			
			superiorList.add(nowHierarchy);

			nextHierarchy=new Hierarchy();
			//最后的情况是：nextHierarchy.ConceptId=1;
			nextHierarchy.setConceptId(nowHierarchy.getSuperiorId());
			

			//重置列表
			nowHierarchy=nextHierarchy;
			nextHierarchy=null;
		}
		
		//添加顶级概念，所以在此手动加入ConceptId=1
		Hierarchy topHierarchy=new Hierarchy();
		topHierarchy.setConceptId(1L);
		topHierarchy.setSequence(1);
		superiorList.add(topHierarchy);
		
		//如果列表只有一项，而且不等于当前值，则置为当前值
		if(superiorList.size()==1) {
			if(!superiorList.getFirst().getConceptId().equals(hierarchy.getConceptId())) {
				superiorList.clear();
				superiorList.add(hierarchy);
			}
		}
		
		
		return superiorList;
	}
	
	


	/**
	 * 查询当前概念的外延直属列表
	 * @param  conceptId,
	 * 			partIdList : 已知的部分父层级Id
	 * 			editingSuperIdListL: 编辑中的父级Id列表[顶级ID,....当前id]
	 * return [顶级id,....当前Id]
	 */
	private List<Long> querySuperiorIdListOnPart(Long conceptId,List<Long> partIdList,List<Long> editingSuperIdList) {
		Long lastPartId=partIdList.get(partIdList.size()-1);
		

		//===========数据结构定义===========
		List<Hierarchy> superiorList=new ArrayList<>();
		
		//当前需要分析的概念
		Hierarchy nowHierarchyModel;

		//下一次需要分析的概念
		Hierarchy nextHierarchyModel;
		

		//===========初始化===========
		Hierarchy hierarchyModelCondition=new Hierarchy(conceptId);
		nowHierarchyModel=hierarchyModelCondition;
		
		

		//===========递归操作准入条件===========
		while(null!=nowHierarchyModel && 1L!= nowHierarchyModel.getConceptId() && !nowHierarchyModel.getConceptId().equals(lastPartId)){
			
			Hierarchy dbNowHierarchyModel=super.pk(nowHierarchyModel);
			
			//新建组分尚未入到层级表
			if(null==dbNowHierarchyModel) {
				Long thisConceptId=nowHierarchyModel.getConceptId();
				Long supConceptId=null;
				for (int i = 0; i < editingSuperIdList.size(); i++) {
					if(thisConceptId.equals(editingSuperIdList.get(i))) {
						if(i>0) {
							supConceptId=editingSuperIdList.get(i-1);
						}
					}
				}
				if(null!=supConceptId) {
					dbNowHierarchyModel=new Hierarchy(thisConceptId);
					dbNowHierarchyModel.setSuperiorId(supConceptId);
				}
				
			}
			
			if(null==dbNowHierarchyModel||null==dbNowHierarchyModel.getSuperiorId()){
				log.error("申请概念版本时，无法找到某节点的父级Id！");
				throw new RuntimeException("申请概念版本时，无法找到某节点的父级Id！");
			}
			
			superiorList.add(dbNowHierarchyModel);

			nextHierarchyModel=new Hierarchy();
			nextHierarchyModel.setConceptId(dbNowHierarchyModel.getSuperiorId());
			

			//重置列表
			nowHierarchyModel=nextHierarchyModel;
			nextHierarchyModel=null;
		}
		
		
		List<Long> superiorIdList=new ArrayList<Long>();
		superiorIdList.addAll(partIdList);
		for (int i = superiorList.size()-1; i >= 0; i--) {
			superiorIdList.add(superiorList.get(i).getConceptId());
		}
		
		return superiorIdList;
	}
	
	
	
	
	
	
}
