package xyz.zhiwei.article.dao.impl.rdb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import xyz.zhiwei.article.morphism.principle.article.model.Contribution;
import xyz.zhiwei.article.morphism.principle.article.qualifier.ContributionReviewCondition;
import xyz.zhiwei.article.morphism.principle.article.qualifier.ContributionReviewQualifier;
//import xyz.hiwei.article.truth.appearance.contribution.qualifier.ContributionQualifier;
import xyz.zhiwei.cognitivedesign.dao.impl.rdb.BaseRdbDaoImpl;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSourcePage;

/**
 * @author zhanghaiting
 */
@Repository
public class ContributionDaoImpl extends BaseRdbDaoImpl<Contribution> {

	
	/**
	 * 子集限定符：概念的正向贡献者分页
	 * @return
	 */
	PrincipleSourcePage<Contribution> conceptIdPositivePage(PrincipleQualifier<Contribution> qualifier){
		Contribution contributionConditon=new Contribution();
		contributionConditon.setConceptId(qualifier.getSimilar().getConceptId());
		contributionConditon.setContribution(-1);
        PrincipleQualifier<Contribution> pq=new PrincipleQualifier<>(Contribution.class,contributionConditon,
        		qualifier.getPageNum(),qualifier.getPageSize());
		return page(pq);
	}
	
	
	
	/**
	 * 子集限定符：概念的正向贡献者分页
	 * @return
	 */
	PrincipleSourcePage<Contribution> conceptIdSpecificPage(ContributionReviewQualifier qualifier){
		
		Long conceptId=qualifier.getSimilar().getConceptId();
		ContributionReviewCondition contributionReviewCondition=qualifier.getContributionReviewCondition();
	    Integer passState=contributionReviewCondition.getPassState();//通过状态
	    Integer activeType=contributionReviewCondition.getActiveType();//动作(新增编辑)类型
		
		
		String tableFieldName=null;
		
	    if(1==passState){
	        switch (activeType){
	            case 0:
	            	tableFieldName="century_is_all";
	                break;
	            case 1:
	            	tableFieldName="century_is_create";
	                break;
	            case 2:
	            	tableFieldName="century_is_edit";
	                break;
	            case 3:
	            	tableFieldName="century_is_discussion";
	                break;
	            default:
	        }
	    }else if(0==passState){
	        switch (activeType){
	            case 0:
	            	tableFieldName="wait_is_all";
	                break;
	            case 1:
	            	tableFieldName="wait_is_create";
	                break;
	            case 2:
	            	tableFieldName="wait_is_edit";
	                break;
	            case 3:
	            	tableFieldName="wait_is_discussion";
	                break;
	            default:
	        }
	    }else if(2==passState){
	        switch (activeType){
	            case 0:
	            	tableFieldName="refuse_is_all";
	                break;
	            case 1:
	            	tableFieldName="refuse_is_create";
	                break;
	            case 2:
	            	tableFieldName="refuse_is_edit";
	                break;
	            case 3:
	            	tableFieldName="refuse_is_discussion";
	                break;
	            default:
	        }
	    }
		

    	Map<String,Object> condition=new HashMap<>();
    	condition.put("conceptId", conceptId);
    	condition.put("tableFieldName", tableFieldName);
    	
    	
		return page(condition,qualifier.getPageNum(),qualifier.getPageSize(),"selectByForeignContributors");
	}
	
	

	/**
	 * 更新：累加统计数
	 * @param list
	 * @return
	 */
	Long updateByPkIncrease(List<Contribution> list) {
    	return updateBatch(list,"updateByPrimaryIncrease");
    }
	

}
