package xyz.zhiwei.explorer.dao.impl.file.support;

import java.io.FileOutputStream;
import java.io.OutputStream;

import org.apache.commons.codec.binary.Base64;

/**
 * @author:Aureole
 * @date:2016年10月15日
 */
public class Base64Image {
	
	/**
	* 注意检查路径
	* @Description: 将base64编码字符串转换为图片
	* @Author: 
	* @CreateTime: 
	* @param imgStr base64编码字符串
	* @param path 图片路径-具体到文件
	* @return
	*/
	public static boolean generateImage(String imgStr, String imgFilePath) {
		
		if (imgStr == null)return false;
		if(imgStr.startsWith("data:image/jpeg;base64,")){
			imgStr=imgStr.substring(23);
		}
		
		try {
            //Base64解码  
            byte[] b = Base64.decodeBase64(imgStr);  
              
            for(int i=0;i<b.length;++i)  
            {  
                if(b[i]<0)  
                {//调整异常数据  
                    b[i]+=256;  
                }  
            }  
            //生成jpeg图片  
            OutputStream out = new FileOutputStream(imgFilePath);      
            out.write(b);  
            out.flush();  
            out.close();  
            return true; 
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	

	/**
	 * 图片字符串解码
	 * @param imgStr
	 * @return
	 */
	public static byte[] imgToByte(String imgStr) {
		if (imgStr == null)return null;
		
		if(imgStr.startsWith("data:image/jpeg;base64,")){
			imgStr=imgStr.substring(23);
		}else if(imgStr.startsWith("data:image/png;base64,")) {
			imgStr=imgStr.substring(22);
		}
		
		try {
            //Base64解码  
            byte[] b = Base64.decodeBase64(imgStr);  
              
            for(int i=0;i<b.length;++i)  
            {  
                if(b[i]<0)  
                {//调整异常数据  
                    b[i]+=256;  
                }  
            }  
            
            
			return b;
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}
}
