package xyz.zhiwei.explorer.dao.impl.file;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import xyz.zhiwei.article.morphism.principle.article.model.ParagraphPicture;
import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.dao.impl.file.support.Base64Image;
import xyz.zhiwei.explorer.dao.impl.file.support.FileDaoConstant;

@Repository
public class ParagraphPictureDaoImpl implements Dao<ParagraphPicture> {
	
	
    @Autowired
    protected FileDaoImpl fileDaoImpl;

	//==========================================接口集===========================================

	@Override
	public List<ParagraphPicture> subCollection(PrincipleQualifier<ParagraphPicture> qualifier) {
		return null;
	}

	@Override
	public Long add(List<ParagraphPicture> list) {
		Integer count=0;
		for(ParagraphPicture picture:list) {
			count+=savePortrait(picture);
		}
		return (long)count;
	}


	@Override
	public Long update(List<ParagraphPicture> list) {
		return Long.valueOf(savePortrait(list.getFirst()));
	}
	
	@Override
	public Long delete(List<ParagraphPicture> list) {
		return 0L;
	}

	//==========================================实现===========================================


	
	/**
	 * 处理段落图片
	 * @param explorerModel
	 * @return
	 */
    private int savePortrait(ParagraphPicture picture){
		String imageName=picture.getId().split(".")[0];//文件名
		
		byte[] imgByte=Base64Image.imgToByte(picture.getName());
		if(null==imgByte){return 0;};
		
		String fileId=fileDaoImpl.upload(FileDaoConstant.DFS_M_PARAGRAPH, FileDaoConstant.DFS_A_IMG, imageName, "jpg", imgByte);
		
		
		if(null==fileId){
			return 0;
		}else{
		    return 1;
		}

    }



	
	
	
	
	
	
}