package xyz.zhiwei.article.api.model;

import xyz.zhiwei.article.morphism.appearance.explorer.viewreview.ContributorReViewInit;
import xyz.zhiwei.article.morphism.appearance.explorer.viewsingle.ContributorSingleInit;

/**
 * 贡献者列表，查询条件
 */
public class ExplorerContributionCondition {

	private Long conceptId;
	private Long explorerId;

    private Integer stateActive=0;//查询状态是否有效：0无效，1有效
    private Integer passState;//通过状态
    private Integer activeType;//动作(新增编辑)类型

    
    /**
     * 获取ContributorReViewInit实例（属性直接映射，无校验）
     * @return ContributorReViewInit实例
     */
    public ContributorReViewInit getContributorReViewInit() {
        return new ContributorReViewInit(this.conceptId, this.passState, this.activeType);
    }

    /**
     * 获取ContributorSingleInit实例（属性直接映射，无校验）
     * @return ContributorSingleInit实例
     */
    public ContributorSingleInit getContributorSingleInit() {
        return new ContributorSingleInit(this.conceptId, this.explorerId);
    }
	
	public Long getConceptId() {
		return conceptId;
	}
	public void setConceptId(Long conceptId) {
		this.conceptId = conceptId;
	}
	public Integer getPassState() {
		return passState;
	}
	public void setPassState(Integer passState) {
		this.passState = passState;
	}
	public Integer getActiveType() {
		return activeType;
	}
	public void setActiveType(Integer activeType) {
		this.activeType = activeType;
	}
	public Long getExplorerId() {
		return explorerId;
	}
	public void setExplorerId(Long explorerId) {
		this.explorerId = explorerId;
	}

	public Integer getStateActive() {
		return stateActive;
	}

	public void setStateActive(Integer stateActive) {
		this.stateActive = stateActive;
	}



}
